/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal.platform.win;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.os.Environment;
import java.util.Arrays;
import java.util.Map;

public final class OsCompatibilityMode {
    private static final String COMPAT_LAYER_VARIABLE = "__COMPAT_LAYER";
    private static final String[] COMPAT_MODES = new String[]{"NT4SP5", "VistaRTM", "VistaSP1", "VistaSP2", "Win7RTM", "Win8RTM"};

    private OsCompatibilityMode() {
    }

    public static void removeIfExists(ProcessBuilder chromiumProcessBuilder) {
        Preconditions.checkState(Environment.isWindows());
        Map<String, String> processEnv = chromiumProcessBuilder.environment();
        String compatLayer = processEnv.get(COMPAT_LAYER_VARIABLE);
        if (compatLayer != null) {
            Logger.debug("__COMPAT_LAYER variable detected: {0}", compatLayer);
            Arrays.stream(COMPAT_MODES).filter(compatLayer::contains).findFirst().ifPresent(osCompatibility -> {
                Logger.debug("OS compatibility mode detected: {0}. Removing it...", osCompatibility);
                processEnv.put(COMPAT_LAYER_VARIABLE, compatLayer.replace((CharSequence)osCompatibility, ""));
            });
        }
    }
}

