/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal.rpc.stream.util;

import com.teamdev.jxbrowser.callback.AsyncCallback;
import com.teamdev.jxbrowser.callback.Callback;
import com.teamdev.jxbrowser.callback.SyncCallback;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.protobuf.Message;
import com.teamdev.jxbrowser.internal.rpc.stream.util.AbstractType;
import com.teamdev.jxbrowser.internal.rpc.stream.util.CallbackType;
import com.teamdev.jxbrowser.internal.rpc.stream.util.MessageType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public final class ParamsType
extends AbstractType<Object> {
    public static <C extends Callback> ParamsType from(CallbackType<C> callbackClass) {
        Preconditions.checkNotNull(callbackClass);
        Preconditions.checkArgument(SyncCallback.class.isAssignableFrom(callbackClass.type()) || AsyncCallback.class.isAssignableFrom(callbackClass.type()));
        Type[] genericInterfaces = callbackClass.type().getGenericInterfaces();
        ParameterizedType parameterizedType = (ParameterizedType)genericInterfaces[0];
        Type requestType = parameterizedType.getActualTypeArguments()[0];
        return new ParamsType((Class<?>)((Class)requestType));
    }

    public static <T extends Message> ParamsType from(MessageType<T> requestClass) {
        Preconditions.checkNotNull(requestClass);
        for (Class<?> type : requestClass.type().getInterfaces()) {
            if (!type.getSimpleName().contains("Params")) continue;
            return new ParamsType(type);
        }
        throw new IllegalArgumentException("Cannot determine the params class for the message: " + requestClass);
    }

    private ParamsType(Class<?> type) {
        super(type);
    }

    @Override
    public String toString() {
        return "ParamsType:" + super.toString();
    }
}

