/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal.xz;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.common.util.concurrent.Uninterruptibles;
import com.teamdev.jxbrowser.internal.SystemProperties;
import com.teamdev.jxbrowser.internal.xz.ExtractionFailed;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.os.Environment;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

final class SevenZip {
    private static final int SUCCESS_EXIT_CODE = 0;
    private static final int WARNING_EXIT_CODE = 1;
    private final Path executable;

    static String executableName() {
        if (Environment.isWindows()) {
            if (Environment.isArm()) {
                return "7zr-arm.exe";
            }
            return "7zr.exe";
        }
        if (Environment.isMac()) {
            return "7zr-mac";
        }
        if (Environment.isLinux() && Environment.is64Bit()) {
            if (Environment.isArm()) {
                return "7zr-linux64-arm";
            }
            return "7zr-linux64";
        }
        throw new IllegalStateException("Unsupported operating system");
    }

    static boolean shouldUseNativeExtraction() {
        return Environment.isLinux() && !Environment.isArm() && !SystemProperties.hasProperty("jxbrowser.jni.extraction.enabled");
    }

    private SevenZip(Path executable) {
        this.executable = executable;
    }

    static SevenZip create(Path executable) {
        Preconditions.checkNotNull(executable);
        return new SevenZip(executable);
    }

    void decompress(Path archive, Path destinationDir) throws ExtractionFailed, IOException, InterruptedException {
        Process xzProcess;
        String executablePath = this.executable.toString();
        String destinationDirPath = destinationDir.toString();
        String archivePath = archive.toString();
        String[] args = new String[]{executablePath, "-aoa", "-o" + destinationDirPath, "x", archivePath};
        try {
            xzProcess = Runtime.getRuntime().exec(args);
        }
        catch (IOException e) {
            if (Environment.isLinux()) {
                Uninterruptibles.sleepUninterruptibly(100L, TimeUnit.MILLISECONDS);
                xzProcess = Runtime.getRuntime().exec(args);
            }
            throw e;
        }
        this.startLogging(xzProcess);
        this.waitFor(xzProcess);
    }

    private void waitFor(Process xzProcess) throws InterruptedException, ExtractionFailed {
        int exitCode = xzProcess.waitFor();
        if (exitCode != 0 && exitCode != 1) {
            throw new ExtractionFailed("7z exited with an error. Exit code: " + exitCode);
        }
    }

    private void startLogging(Process process) {
        this.startLogging("out", process.getInputStream(), Logger::info);
        this.startLogging("error", process.getErrorStream(), Logger::debug);
    }

    private void startLogging(String logName, InputStream inputStream, Consumer<String> logger) {
        Thread processConsoleThread = new Thread(() -> {
            try {
                String line;
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
                BufferedReader input = new BufferedReader(inputStreamReader);
                StringBuilder builder = new StringBuilder();
                while ((line = input.readLine()) != null) {
                    builder.append(line).append("\n");
                }
                logger.accept(builder.toString());
                input.close();
            }
            catch (IOException e) {
                Logger.error("Failed to log process output.", e);
            }
        }, String.format("XZ Logger (%s)", logName));
        processConsoleThread.setDaemon(true);
        processConsoleThread.start();
    }
}

