/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.net.callback;

import com.teamdev.jxbrowser.annotation.Immutable;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableList;
import com.teamdev.jxbrowser.internal.rpc.Protobuf;
import com.teamdev.jxbrowser.net.Host;
import com.teamdev.jxbrowser.net.callback.NetworkSyncCallback;
import com.teamdev.jxbrowser.net.internal.rpc.CertVerificationStatusList;
import com.teamdev.jxbrowser.net.internal.rpc.VerifyCertificate;
import com.teamdev.jxbrowser.net.tls.CertVerificationError;
import com.teamdev.jxbrowser.net.tls.CertVerificationStatus;
import com.teamdev.jxbrowser.net.tls.Certificate;
import java.util.List;
import java.util.stream.Collectors;

public interface VerifyCertificateCallback
extends NetworkSyncCallback<Params, Response> {

    public static interface Response {
        public static Response valid() {
            return VerifyCertificate.Response.newBuilder().setValid(Protobuf.empty()).build();
        }

        public static Response invalid(CertVerificationStatus ... verificationStatuses) {
            Preconditions.checkNotNull(verificationStatuses);
            CertVerificationStatusList statusList = CertVerificationStatusList.newBuilder().addAllVerificationStatus(ImmutableList.copyOf(verificationStatuses)).build();
            return VerifyCertificate.Response.newBuilder().setInvalid(statusList).build();
        }

        public static Response defaultAction() {
            return VerifyCertificate.Response.newBuilder().setDefault(Protobuf.empty()).build();
        }
    }

    public static interface Params {
        default public Host host() {
            return ((VerifyCertificate.Request)this).getHost();
        }

        default public Certificate certificate() {
            return ((VerifyCertificate.Request)this).getCertificate();
        }

        @Immutable
        default public List<Certificate> intermediateCertificates() {
            return ((VerifyCertificate.Request)this).getIntermediateCertificatesList().stream().map(certificate -> certificate).collect(Collectors.toList());
        }

        @Immutable
        default public List<CertVerificationError> verificationErrors() {
            return ImmutableList.copyOf(((VerifyCertificate.Request)this).getVerificationErrorList());
        }

        @Deprecated(since="7.26", forRemoval=true)
        @Immutable
        default public List<CertVerificationStatus> verificationStatuses() {
            ImmutableList.Builder result = ImmutableList.builder();
            this.verificationErrors().stream().map(CertVerificationError::status).forEach(result::add);
            return result.build();
        }
    }
}

