/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.print.internal;

import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.internal.Lazy;
import com.teamdev.jxbrowser.print.Capabilities;
import com.teamdev.jxbrowser.print.PdfPrinter;
import com.teamdev.jxbrowser.print.PrintSettings;
import com.teamdev.jxbrowser.print.SystemPrinter;
import com.teamdev.jxbrowser.print.internal.PrintJobImpl;
import com.teamdev.jxbrowser.print.internal.rpc.Printer;
import com.teamdev.jxbrowser.print.internal.settings.PrintSettingsConstructor;

public final class PrinterImpl<PrintSettingsT extends PrintSettings>
implements PdfPrinter<PrintSettingsT>,
SystemPrinter<PrintSettingsT> {
    private final Printer printer;
    private final Lazy<PrintJobImpl<PrintSettingsT>> printJob;

    PrinterImpl(Printer printer, BrowserImpl browser, PrintSettingsConstructor<PrintSettingsT> ctor) {
        this.printer = printer;
        this.printJob = new Lazy<PrintJobImpl>(() -> new PrintJobImpl(browser, printer.getPrintJobId(), ctor));
    }

    @Override
    public String deviceName() {
        return this.printer.getDisplayName();
    }

    @Override
    public String printerName() {
        return this.printer.getPrinterName();
    }

    @Override
    public Capabilities capabilities() {
        return ((PrintJobImpl)this.printJob()).capabilities();
    }

    @Override
    public PrintJobImpl<PrintSettingsT> printJob() {
        return this.printJob.get();
    }

    public boolean isDefault() {
        return this.printer.getDefault();
    }

    public Printer printer() {
        return this.printer;
    }

    public void applySettings() {
        if (((PrintJobImpl)this.printJob()).settings() instanceof PdfPrinter.Settings) {
            PdfPrinter.Settings settings = (PdfPrinter.Settings)((PrintJobImpl)this.printJob()).settings();
            Preconditions.checkState(settings.pdfFilePath().isPresent(), "The PDF file path is not specified.");
        }
        ((PrintJobImpl)this.printJob()).settings().apply();
    }
}

