/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.search.internal;

import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.Wrappers;
import com.teamdev.jxbrowser.internal.rpc.BrowserId;
import com.teamdev.jxbrowser.internal.rpc.FindRequestId;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import com.teamdev.jxbrowser.search.FindOptions;
import com.teamdev.jxbrowser.search.FindResult;
import com.teamdev.jxbrowser.search.TextFinder;
import com.teamdev.jxbrowser.search.internal.rpc.FindReplyReceived;
import com.teamdev.jxbrowser.search.internal.rpc.FindRequest;
import com.teamdev.jxbrowser.search.internal.rpc.FindResult;
import com.teamdev.jxbrowser.search.internal.rpc.StopFindingRequest;
import com.teamdev.jxbrowser.search.internal.rpc.TextFinderStub;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public final class TextFinderImpl
extends CloseableImpl
implements TextFinder {
    private static final AtomicInteger nextId = new AtomicInteger();
    private final BrowserImpl browser;
    private final Subscription findReplyReceived;
    private final ServiceConnectionImpl<TextFinderStub> rpc;
    private final Map<FindRequestId, Consumer<FindResult>> consumers;

    public TextFinderImpl(BrowserImpl browser) {
        Preconditions.checkNotNull(browser);
        this.browser = browser;
        this.consumers = new HashMap<FindRequestId, Consumer<FindResult>>();
        this.rpc = this.connect();
        this.findReplyReceived = this.rpc.on(FindReplyReceived.class, this::handleFindReply);
    }

    private ServiceConnectionImpl<TextFinderStub> connect() {
        BrowserId id = this.browserId();
        Connection connection = this.browser.engine().connection();
        return new ServiceConnectionImpl<TextFinderStub>(id, connection, TextFinderStub::new);
    }

    private void handleFindReply(FindReplyReceived event) {
        FindRequestId requestId = event.getFindRequestId();
        if (this.consumers.containsKey(requestId)) {
            Consumer<FindResult> callback = this.consumers.get(requestId);
            if (event.getResult().getState() == FindResult.State.FINISHED) {
                callback = this.consumers.remove(requestId);
            }
            callback.accept(event.getResult());
        }
    }

    private BrowserId browserId() {
        return this.browser.id();
    }

    private TextFinderStub stub() {
        return this.rpc.stub();
    }

    @Override
    public void close() {
        this.findReplyReceived.unsubscribe();
        super.close();
    }

    @Override
    public Browser browser() {
        return this.browser;
    }

    @Override
    public void find(String text, Consumer<FindResult> consumer) {
        this.find(text, FindOptions.newBuilder().build(), consumer);
    }

    @Override
    public void find(String text, FindOptions options, Consumer<FindResult> consumer) {
        Preconditions.checkNotNull(text);
        Preconditions.checkArgument(!text.isEmpty());
        Preconditions.checkNotNull(options);
        Preconditions.checkNotNull(consumer);
        this.checkNotClosed();
        FindRequestId requestId = FindRequestId.newBuilder().setValue(nextId.incrementAndGet()).build();
        this.consumers.put(requestId, consumer);
        FindRequest request = FindRequest.newBuilder().setBrowserId(this.browserId()).setSearchText(text).setOptions(Wrappers.unwrap(options, com.teamdev.jxbrowser.search.internal.rpc.FindOptions.class)).setFindRequestId(requestId).build();
        this.rpc.invokeAsync(this.stub()::find, request);
    }

    @Override
    public void stopFindingAndKeepSelection() {
        this.checkNotClosed();
        this.stopFinding(StopFindingRequest.StopFindAction.KEEP_SELECTION);
    }

    @Override
    public void stopFindingAndClearSelection() {
        this.checkNotClosed();
        this.stopFinding(StopFindingRequest.StopFindAction.CLEAR_SELECTION);
    }

    private void stopFinding(StopFindingRequest.StopFindAction stopFindAction) {
        StopFindingRequest request = StopFindingRequest.newBuilder().setBrowserId(this.browserId()).setAction(stopFindAction).build();
        this.rpc.invoke(this.stub()::stopFinding, request);
    }
}

