/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.ui.internal;

import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableMap;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableSet;
import com.teamdev.jxbrowser.frame.EditorCommand;
import com.teamdev.jxbrowser.ui.KeyCode;
import com.teamdev.jxbrowser.ui.KeyModifiers;
import com.teamdev.jxbrowser.ui.event.KeyPressed;
import com.teamdev.jxbrowser.ui.internal.KeyEvents;
import com.teamdev.jxbrowser.ui.internal.MacEditorCommand;
import java.util.Optional;

final class CommandMapping {
    private static final KeyModifiers META = MacEditorCommand.metaDown();
    private static final ImmutableSet<KeyModifiers> META_DOWN = ImmutableSet.of(META);
    private static final ImmutableSet<KeyModifiers> META_AND_SHIFT_DOWN = ImmutableSet.of(META, MacEditorCommand.shiftDown());
    private static final ImmutableSet<KeyModifiers> ALT_DOWN = ImmutableSet.of(MacEditorCommand.altDown());
    private final ImmutableMap<KeyPressed, EditorCommand> commands;

    private CommandMapping(Builder builder) {
        this.commands = builder.commands.build();
    }

    Optional<EditorCommand> commandFor(KeyPressed event) {
        KeyPressed keyPressed = KeyEvents.onlyCodeAndModifiers(event);
        EditorCommand command = this.commands.get(keyPressed);
        return Optional.ofNullable(command);
    }

    static Builder newBuilder() {
        return new Builder();
    }

    static final class Builder {
        private final ImmutableMap.Builder<KeyPressed, EditorCommand> commands = ImmutableMap.builder();

        private Builder() {
        }

        Builder withMetaDown(EditorCommand command, KeyCode keyCode) {
            this.put(command, keyCode, META_DOWN);
            return this;
        }

        Builder withMetaAndShiftDown(EditorCommand command, KeyCode keyCode) {
            this.put(command, keyCode, META_AND_SHIFT_DOWN);
            return this;
        }

        Builder withAltDown(EditorCommand command, KeyCode keyCode) {
            this.put(command, keyCode, ALT_DOWN);
            return this;
        }

        private void put(EditorCommand command, KeyCode keyCode, ImmutableSet<KeyModifiers> modifiers) {
            KeyPressed keyStroke = KeyEvents.keyStroke(keyCode, modifiers);
            this.commands.put(keyStroke, command);
        }

        CommandMapping build() {
            return new CommandMapping(this);
        }
    }
}

