/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.ui.internal;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableList;
import com.teamdev.jxbrowser.internal.string.StringPreconditions;
import com.teamdev.jxbrowser.ui.internal.Action;
import java.util.List;
import java.util.function.Consumer;

public abstract class DefaultDialog<D extends DefaultDialog<D>> {
    protected final String title;
    protected final String message;
    protected final List<Action<D>> actions;
    protected final Runnable defaultCallback;
    protected boolean actionSelected;

    protected DefaultDialog(Builder<D, ?> builder) {
        this.message = builder.message;
        this.actions = builder.actions.build();
        this.defaultCallback = builder.defaultCallback;
        this.title = builder.title;
    }

    public abstract void open();

    protected abstract D self();

    public static abstract class Builder<D extends DefaultDialog<D>, B extends Builder<D, B>> {
        private final String message;
        private final ImmutableList.Builder<Action<D>> actions;
        private String title;
        private Runnable defaultCallback;

        protected Builder(String message) {
            StringPreconditions.checkNotNullEmptyOrBlank(message);
            this.message = message;
            this.actions = ImmutableList.builder();
        }

        public B title(String title) {
            StringPreconditions.checkNotNullEmptyOrBlank(title);
            this.title = title;
            return this.self();
        }

        public B addButton(String label, Consumer<D> callback) {
            Preconditions.checkNotNull(callback);
            StringPreconditions.checkNotNullEmptyOrBlank(label);
            this.actions.add((Object)new Action<D>(label, callback));
            return this.self();
        }

        public B addButton(String label, Runnable callback) {
            Preconditions.checkNotNull(callback);
            StringPreconditions.checkNotNullEmptyOrBlank(label);
            this.actions.add((Object)new Action<DefaultDialog>(label, ignored -> callback.run()));
            return this.self();
        }

        public B defaultAction(Runnable callback) {
            Preconditions.checkNotNull(callback);
            this.defaultCallback = callback;
            return this.self();
        }

        public final D build() {
            Preconditions.checkNotNull(this.message);
            Preconditions.checkNotNull(this.defaultCallback);
            return this.createDialog();
        }

        protected abstract D createDialog();

        protected abstract B self();
    }
}

