/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.ui.internal;

import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.Rect;
import com.teamdev.jxbrowser.ui.Size;

public final class Geometry {
    public static Rect newRect(double x, double y, double width, double height) {
        return Rect.of(Geometry.newPoint(x, y), Size.of((int)width, (int)height));
    }

    public static Point newPoint(double x, double y) {
        return Point.of((int)x, (int)y);
    }

    public static Rect scaleDown(Rect rect, double scaleFactor) {
        return Rect.of(Geometry.scaleDown(rect.origin(), scaleFactor), Geometry.scaleDown(rect.size(), scaleFactor));
    }

    public static Point scaleDown(Point point, double scaleFactor) {
        return Point.of((int)((double)point.x() / scaleFactor), (int)((double)point.y() / scaleFactor));
    }

    public static Size scaleDown(Size size, double scaleFactor) {
        return Size.of((int)((double)size.width() / scaleFactor), (int)((double)size.height() / scaleFactor));
    }

    public static Rect scaleUp(Rect rect, double scaleFactor) {
        return Rect.of(Geometry.scaleUp(rect.origin(), scaleFactor), Geometry.scaleUp(rect.size(), scaleFactor));
    }

    public static Point scaleUp(Point point, double scaleFactor) {
        return Point.of((int)((double)point.x() * scaleFactor), (int)((double)point.y() * scaleFactor));
    }

    public static Size scaleUp(Size size, double scaleFactor) {
        return Size.of((int)((double)size.width() * scaleFactor), (int)((double)size.height() * scaleFactor));
    }

    private Geometry() {
    }
}

