/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.internal;

import com.teamdev.jxbrowser.card.CreditCard;
import com.teamdev.jxbrowser.card.CreditCardNetwork;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableList;
import com.teamdev.jxbrowser.user.Address;
import com.teamdev.jxbrowser.user.UserDataProfile;
import java.util.EnumMap;
import java.util.List;

public final class Bubbles {
    public static final String SAVE_LABEL = "Save";
    public static final String UPDATE_LABEL = "Update";
    public static final String NO_THANKS_LABEL = "No, thanks";
    public static final String NEVER_LABEL = "Never";
    private static final int NUMBER_OF_DISPLAYED_DIGITS = 4;
    private static final EnumMap<CreditCardNetwork, String> creditCardNetworkNames = new EnumMap(CreditCardNetwork.class);

    public static String createSavePasswordBubbleMessage(String login) {
        return String.format("Save password?%n%s", login);
    }

    public static String createUpdatePasswordBubbleMessage(String login) {
        return String.format("Update password?%n%s", login);
    }

    public static String createSaveCardBubbleMessage(CreditCard creditCard) {
        String number = creditCard.number();
        String header = String.format("%s%n%n", "Save card?");
        String networkName = Bubbles.creditCardNetworkName(creditCard.network());
        String dots = "  . . . . ";
        String numberToDisplay = number.substring(number.length() - 4);
        String expirationDate = String.format("%n%d/%d", creditCard.expirationMonth().getValue(), creditCard.expirationYear());
        return header + networkName + dots + numberToDisplay + expirationDate;
    }

    public static String createSaveAddressBubbleMessage(UserDataProfile profile) {
        String header = String.format("%s%n%n", "Save address?");
        List<String> nonEmptyValues = Bubbles.collectNonEmptyUserDataProfileValues(profile);
        StringBuilder bubbleMessage = new StringBuilder(header);
        nonEmptyValues.forEach(value -> bubbleMessage.append((String)value).append(System.lineSeparator()));
        return bubbleMessage.toString();
    }

    public static String createUpdateAddressBubbleMessage(UserDataProfile oldProfile, UserDataProfile newProfile) {
        String header = String.format("%s%n%n", "Update address?");
        String fullName = String.format("%s%n%n", oldProfile.fullName());
        String userDataDifferences = Bubbles.findUserDataProfilesDifferences(oldProfile, newProfile);
        return header + fullName + userDataDifferences;
    }

    private static String findUserDataProfilesDifferences(UserDataProfile oldProfile, UserDataProfile newProfile) {
        String lineSeparator = System.lineSeparator();
        List<String> oldValues = Bubbles.collectUserDataProfileValues(oldProfile);
        List<String> newValues = Bubbles.collectUserDataProfileValues(newProfile);
        StringBuilder newValueResult = new StringBuilder("New:" + lineSeparator);
        StringBuilder oldValueResult = new StringBuilder("Old:" + lineSeparator);
        for (int i = 0; i < newValues.size(); ++i) {
            if (oldValues.get(i).equals(newValues.get(i))) continue;
            newValueResult.append(newValues.get(i)).append(lineSeparator);
            oldValueResult.append(oldValues.get(i)).append(lineSeparator);
        }
        return newValueResult.append(lineSeparator).append((CharSequence)oldValueResult).toString();
    }

    private static String creditCardNetworkName(CreditCardNetwork network) {
        return creditCardNetworkNames.getOrDefault(network, "Unknown network type");
    }

    private static List<String> collectUserDataProfileValues(UserDataProfile profile) {
        Address address = profile.address();
        return ImmutableList.of(profile.fullName(), profile.companyName(), address.streetAddress(), address.city(), address.dependentLocality(), address.state(), address.countryCode(), address.zip(), profile.phoneNumber(), profile.email());
    }

    private static List<String> collectNonEmptyUserDataProfileValues(UserDataProfile profile) {
        return Bubbles.collectUserDataProfileValues(profile).stream().filter(value -> !value.isEmpty()).collect(ImmutableList.toImmutableList());
    }

    private Bubbles() {
    }

    static {
        creditCardNetworkNames.put(CreditCardNetwork.AMERICAN_EXPRESS, "American Express");
        creditCardNetworkNames.put(CreditCardNetwork.DINERS, "Diners");
        creditCardNetworkNames.put(CreditCardNetwork.DISCOVER, "Discover");
        creditCardNetworkNames.put(CreditCardNetwork.ELO, "Elo");
        creditCardNetworkNames.put(CreditCardNetwork.GENERIC, "Generic");
        creditCardNetworkNames.put(CreditCardNetwork.JCB, "JCB");
        creditCardNetworkNames.put(CreditCardNetwork.MASTER_CARD, "Mastercard");
        creditCardNetworkNames.put(CreditCardNetwork.TROY, "Troy");
        creditCardNetworkNames.put(CreditCardNetwork.UNION_PAY, "UnionPay");
        creditCardNetworkNames.put(CreditCardNetwork.VISA, "Visa");
    }
}

